//==========================  Open Steamworks  ================================
//
// This file is part of the Open Steamworks project. All individuals associated
// with this project do not claim ownership of the contents
// 
// The code, comments, and all related files, projects, resources,
// redistributables included with this project are Copyright Valve Corporation.
// Additionally, Valve, the Valve logo, Half-Life, the Half-Life logo, the
// Lambda logo, Steam, the Steam logo, Team Fortress, the Team Fortress logo,
// Opposing Force, Day of Defeat, the Day of Defeat logo, Counter-Strike, the
// Counter-Strike logo, Source, the Source logo, and Counter-Strike Condition
// Zero are trademarks and or registered trademarks of Valve Corporation.
// All other trademarks are property of their respective owners.
//
//=============================================================================

#ifndef HTTPCOMMON_H
#define HTTPCOMMON_H
#ifdef _WIN32
#pragma once
#endif


#define CLIENTHTTP_INTERFACE_VERSION "CLIENTHTTP_INTERFACE_VERSION001"
#define STEAMHTTP_INTERFACE_VERSION_001 "STEAMHTTP_INTERFACE_VERSION001"
#define STEAMHTTP_INTERFACE_VERSION_002 "STEAMHTTP_INTERFACE_VERSION002"
#define STEAMHTTP_INTERFACE_VERSION_003 "STEAMHTTP_INTERFACE_VERSION003"

typedef uint32 HTTPRequestHandle;
#define INVALID_HTTPREQUEST_HANDLE		0

typedef uint32 HTTPCookieContainerHandle;
#define INVALID_HTTPCOOKIE_HANDLE		0

// This enum is used in client API methods, do not re-number existing values.
enum EHTTPMethod
{
	k_EHTTPMethodInvalid = 0,
	k_EHTTPMethodGET,
	k_EHTTPMethodHEAD,
	k_EHTTPMethodPOST,
	k_EHTTPMethodPUT,
	k_EHTTPMethodDELETE,

	// The remaining HTTP methods are not yet supported, per rfc2616 section 5.1.1 only GET and HEAD are required for 
	// a compliant general purpose server.  We'll likely add more as we find uses for them.

	// k_EHTTPMethodOPTIONS,
	// k_EHTTPMethodTRACE,
	// k_EHTTPMethodCONNECT
};


// HTTP Status codes that the server can send in response to a request, see rfc2616 section 10.3 for descriptions
// of each of these.
typedef enum EHTTPStatusCode
{
	// Invalid status code (this isn't defined in HTTP, used to indicate unset in our code)
	k_EHTTPStatusCodeInvalid =					0,

	// Informational codes
	k_EHTTPStatusCode100Continue =				100,
	k_EHTTPStatusCode101SwitchingProtocols =	101,

	// Success codes
	k_EHTTPStatusCode200OK =					200,
	k_EHTTPStatusCode201Created =				201,
	k_EHTTPStatusCode202Accepted =				202,
	k_EHTTPStatusCode203NonAuthoritative =		203,
	k_EHTTPStatusCode204NoContent =				204,
	k_EHTTPStatusCode205ResetContent =			205,
	k_EHTTPStatusCode206PartialContent =		206,

	// Redirection codes
	k_EHTTPStatusCode300MultipleChoices =		300,
	k_EHTTPStatusCode301MovedPermanently =		301,
	k_EHTTPStatusCode302Found =					302,
	k_EHTTPStatusCode303SeeOther =				303,
	k_EHTTPStatusCode304NotModified =			304,
	k_EHTTPStatusCode305UseProxy =				305,
	//k_EHTTPStatusCode306Unused =				306, (used in old HTTP spec, now unused in 1.1)
	k_EHTTPStatusCode307TemporaryRedirect =		307,

	// Error codes
	k_EHTTPStatusCode400BadRequest =			400,
	k_EHTTPStatusCode401Unauthorized =			401,
	k_EHTTPStatusCode402PaymentRequired =		402, // This is reserved for future HTTP specs, not really supported by clients
	k_EHTTPStatusCode403Forbidden =				403,
	k_EHTTPStatusCode404NotFound =				404,
	k_EHTTPStatusCode405MethodNotAllowed =		405,
	k_EHTTPStatusCode406NotAcceptable =			406,
	k_EHTTPStatusCode407ProxyAuthRequired =		407,
	k_EHTTPStatusCode408RequestTimeout =		408,
	k_EHTTPStatusCode409Conflict =				409,
	k_EHTTPStatusCode410Gone =					410,
	k_EHTTPStatusCode411LengthRequired =		411,
	k_EHTTPStatusCode412PreconditionFailed =	412,
	k_EHTTPStatusCode413RequestEntityTooLarge =	413,
	k_EHTTPStatusCode414RequestURITooLong =		414,
	k_EHTTPStatusCode415UnsupportedMediaType =	415,
	k_EHTTPStatusCode416RequestedRangeNotSatisfiable = 416,
	k_EHTTPStatusCode417ExpectationFailed =		417,
	k_EHTTPStatusCode429TooManyRequests	=		429,

	// Server error codes
	k_EHTTPStatusCode500InternalServerError =	500,
	k_EHTTPStatusCode501NotImplemented =		501,
	k_EHTTPStatusCode502BadGateway =			502,
	k_EHTTPStatusCode503ServiceUnavailable =	503,
	k_EHTTPStatusCode504GatewayTimeout =		504,
	k_EHTTPStatusCode505HTTPVersionNotSupported = 505,
} EHTTPStatusCode;


struct HTTPRequestCompleted_t
{
	enum { k_iCallback = k_iClientHTTPCallbacks + 1 };

	// Handle value for the request that has completed.
	HTTPRequestHandle m_hRequest;

	// Context value that the user defined on the request that this callback is associated with, 0 if
	// no context value was set.
	uint64 m_ulContextValue;

	// This will be true if we actually got any sort of response from the server (even an error).  
	// It will be false if we failed due to an internal error or client side network failure.
	bool m_bRequestSuccessful;

	// Will be the HTTP status code value returned by the server, k_EHTTPStatusCode200OK is the normal
	// OK response, if you get something else you probably need to treat it as a failure.
	EHTTPStatusCode m_eStatusCode;

	uint32 m_unBodySize; // Same as GetHTTPResponseBodySize()
};

struct HTTPRequestHeadersReceived_t
{
	enum { k_iCallback = k_iClientHTTPCallbacks + 2 };

	// Handle value for the request that has received headers.
	HTTPRequestHandle m_hRequest;

	// Context value that the user defined on the request that this callback is associated with, 0 if
	// no context value was set.
	uint64 m_ulContextValue;
};

struct HTTPRequestDataReceived_t
{
	enum { k_iCallback = k_iClientHTTPCallbacks + 3 };

	// Handle value for the request that has received data.
	HTTPRequestHandle m_hRequest;

	// Context value that the user defined on the request that this callback is associated with, 0 if
	// no context value was set.
	uint64 m_ulContextValue;


	// Offset to provide to GetHTTPStreamingResponseBodyData to get this chunk of data
	uint32 m_cOffset;

	// Size to provide to GetHTTPStreamingResponseBodyData to get this chunk of data
	uint32 m_cBytesReceived;
};


#endif // HTTPCOMMON_H
